Vue.component('v-wareki-gengo-input', {
    props: {
        value: {
            type: String,
            default: 0
        }
    },
    template:
        '<select v-model="value">'+
            '<option></option>'+
            '<option v-for="(gengo,index) in $parent.gengoData" :value="index" v-text="gengo.text"></option>'+
        '</div>',
    watch: {
        value: function(value) {

            this.$emit('input', value);

        }
    }

});

Vue.component('v-wareki-year-input', {
    props: {
        max: {
            type: Number,
            default: 0
        },
        value: {
            type: Number,
            default: 0
        }
    },
    template:
        '<select v-model="value">'+
            '<option></option>'+
            '<option v-for="i in max" :value="i" v-text="year(i)"></option>'+
        '</select>',
    methods: {
        year: function(i) {

            if(i == 1) {

                return '元年';

            }

            return i +'年';

        }
    },
    watch: {
        value: function(value) {

            this.$emit('input', value);

        }
    }

});

Vue.component('v-wareki-input', {
    props: {
        value: {
            type: Number,
            default: 0
        }
    },
    template: '<span>'+
                '<v-wareki-gengo-input v-model="gengoIndex"></v-wareki-gengo-input>&nbsp;'+
                '<v-wareki-year-input :max="maxGengoYear" v-model="gengoYear"></v-wareki-year-input>&nbsp;'+
                '</span>',
    data: function() {
        return {
            gengoIndex: '',
            gengoYear: 0,
            gengoData: [
                {text: '明治', base: 1867, max: 45},
                {text: '大正', base: 1911, max: 15},
                {text: '昭和', base: 1925, max: 63},
                {text: '平成', base: 1988, max: 30},
            ],
            initialized: false
        }
    },
    methods: {
        calcYear: function() {

            var year = null;

            if(this.hasGengo && this.gengoYear > 0) {

                var gengo = this.gengoData[this.gengoIndex];
                year = this.gengoYear + gengo.base;

            }

            this.$emit('input', year);

        }
    },
    computed: {
        hasGengo: function() {

            return (this.gengoData[this.gengoIndex] != undefined);

        },
        selectingGengo: function() {

            return (this.hasGengo)
                ? this.gengoData[this.gengoIndex]
                : null;

        },
        maxGengoYear: function() {

            return (this.hasGengo)
                ? this.selectingGengo.max
                : 0;

        }
    },
    mounted: function() {

        if(this.value > 0) {

            for(var i in this.gengoData) {

                var gengo = this.gengoData[i];

                if(this.value > gengo.base) {

                    this.gengoIndex = i;
                    this.gengoYear = this.value - gengo.base;

                }

            }

        }

        var self = this;

        Vue.nextTick(function(){

            self.initialized = true;

        });

    },
    watch: {
        gengoIndex: function() {

            if(this.initialized && this.hasGengo) {

                this.gengoYear = 0;

            }

            this.calcYear();

        },
        gengoYear: function() {

            this.calcYear();

        }
    }
});